/*
 * Decompiled with CFR 0.152.
 */
package j2html.tags;

import j2html.attributes.Attribute;
import j2html.tags.DomContent;
import j2html.tags.IInstance;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class Tag<T extends Tag<T>>
extends DomContent
implements IInstance<T> {
    private final String tagName;
    private final ArrayList<Attribute> attributes;

    protected Tag(String tagName) {
        this.tagName = tagName;
        this.attributes = new ArrayList();
    }

    public String getTagName() {
        return this.tagName;
    }

    protected boolean hasTagName() {
        return this.tagName != null && !this.tagName.isEmpty();
    }

    protected ArrayList<Attribute> getAttributes() {
        return this.attributes;
    }

    boolean setAttribute(String name, String value) {
        if (value == null) {
            return this.attributes.add(new Attribute(name));
        }
        for (Attribute attribute : this.attributes) {
            if (!attribute.getName().equals(name)) continue;
            attribute.setValue(value);
            return true;
        }
        return this.attributes.add(new Attribute(name, value));
    }

    public T attr(String attribute, Object value) {
        this.setAttribute(attribute, value == null ? null : String.valueOf(value));
        return (T)((Tag)this.self());
    }

    public T attr(Attribute attribute) {
        Iterator<Attribute> iterator = this.attributes.iterator();
        String name = attribute.getName();
        if (name != null) {
            while (iterator.hasNext()) {
                Attribute existingAttribute = iterator.next();
                if (!existingAttribute.getName().equals(name)) continue;
                iterator.remove();
            }
        }
        this.attributes.add(attribute);
        return (T)((Tag)this.self());
    }

    public T attr(String attribute) {
        return this.attr(attribute, null);
    }

    public T condAttr(boolean condition, String attribute, String value) {
        return (T)(condition ? this.attr(attribute, value) : (Tag)this.self());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Tag)) {
            return false;
        }
        return ((Tag)obj).render().equals(this.render());
    }

    public T withClasses(String ... classes) {
        StringBuilder sb = new StringBuilder();
        for (String s : classes) {
            sb.append(s != null ? s : "").append(" ");
        }
        return this.attr("class", sb.toString().trim());
    }

    public T withAccesskey(String accesskey) {
        return this.attr("accesskey", accesskey);
    }

    public T withClass(String className) {
        return this.attr("class", className);
    }

    public T isContenteditable() {
        return this.attr("contenteditable", "true");
    }

    public T withData(String dataAttr, String value) {
        return this.attr("data-" + dataAttr, value);
    }

    public T withDir(String dir) {
        return this.attr("dir", dir);
    }

    public T isDraggable() {
        return this.attr("draggable", "true");
    }

    public T isHidden() {
        return this.attr("hidden", null);
    }

    public T withId(String id) {
        return this.attr("id", id);
    }

    public T withIs(String element) {
        return this.attr("is", element);
    }

    public T withLang(String lang) {
        return this.attr("lang", lang);
    }

    public T withSlot(String name) {
        return this.attr("slot", name);
    }

    public T isSpellcheck() {
        return this.attr("spellcheck", "true");
    }

    public T withStyle(String style) {
        return this.attr("style", style);
    }

    public T withTabindex(int index) {
        return this.attr("tabindex", index);
    }

    public T withTitle(String title) {
        return this.attr("title", title);
    }

    public T isTranslate() {
        return this.attr("translate", "yes");
    }

    public T withCondAccessKey(boolean condition, String accesskey) {
        return this.condAttr(condition, "accesskey", accesskey);
    }

    public T withCondClass(boolean condition, String className) {
        return this.condAttr(condition, "class", className);
    }

    public T withCondContenteditable(boolean condition) {
        return this.attr("contenteditable", condition ? "true" : "false");
    }

    public T withCondData(boolean condition, String dataAttr, String value) {
        return this.condAttr(condition, "data-" + dataAttr, value);
    }

    public T withCondDir(boolean condition, String dir) {
        return this.condAttr(condition, "dir", dir);
    }

    public T withCondDraggable(boolean condition) {
        return this.attr("draggable", condition ? "true" : "false");
    }

    public T withCondHidden(boolean condition) {
        return this.condAttr(condition, "hidden", null);
    }

    public T withCondId(boolean condition, String id) {
        return this.condAttr(condition, "id", id);
    }

    public T withCondIs(boolean condition, String element) {
        return this.condAttr(condition, "is", element);
    }

    public T withCondLang(boolean condition, String lang) {
        return this.condAttr(condition, "lang", lang);
    }

    public T withCondSlot(boolean condition, String name) {
        return this.condAttr(condition, "slot", name);
    }

    public T withCondSpellcheck(boolean condition) {
        return this.attr("spellcheck", condition ? "true" : "false");
    }

    public T withCondStyle(boolean condition, String style) {
        return this.condAttr(condition, "style", style);
    }

    public T withCondTabindex(boolean condition, int index) {
        return this.condAttr(condition, "tabindex", index + "");
    }

    public T withCondTitle(boolean condition, String title) {
        return this.condAttr(condition, "title", title);
    }

    public T withCondTranslate(boolean condition) {
        return this.attr("translate", condition ? "yes" : "no");
    }
}

