/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import org.apache.storm.annotation.InterfaceStability;
import org.apache.storm.streams.Node;
import org.apache.storm.streams.Pair;
import org.apache.storm.streams.ProcessorNode;
import org.apache.storm.streams.Stream;
import org.apache.storm.streams.StreamBuilder;
import org.apache.storm.streams.StreamState;
import org.apache.storm.streams.WindowNode;
import org.apache.storm.streams.operations.BiFunction;
import org.apache.storm.streams.operations.CombinerAggregator;
import org.apache.storm.streams.operations.Consumer;
import org.apache.storm.streams.operations.FlatMapFunction;
import org.apache.storm.streams.operations.Function;
import org.apache.storm.streams.operations.PairValueJoiner;
import org.apache.storm.streams.operations.Predicate;
import org.apache.storm.streams.operations.Reducer;
import org.apache.storm.streams.operations.StateUpdater;
import org.apache.storm.streams.operations.ValueJoiner;
import org.apache.storm.streams.operations.aggregators.Count;
import org.apache.storm.streams.processors.AggregateByKeyProcessor;
import org.apache.storm.streams.processors.CoGroupByKeyProcessor;
import org.apache.storm.streams.processors.FlatMapValuesProcessor;
import org.apache.storm.streams.processors.JoinProcessor;
import org.apache.storm.streams.processors.MapValuesProcessor;
import org.apache.storm.streams.processors.MergeAggregateByKeyProcessor;
import org.apache.storm.streams.processors.ReduceByKeyProcessor;
import org.apache.storm.streams.processors.UpdateStateByKeyProcessor;
import org.apache.storm.streams.windowing.Window;
import org.apache.storm.tuple.Fields;

@InterfaceStability.Unstable
public class PairStream<K, V>
extends Stream<Pair<K, V>> {
    PairStream(StreamBuilder topology, Node node) {
        super(topology, node);
        node.setEmitsPair(true);
    }

    public <R> PairStream<K, R> mapValues(Function<? super V, ? extends R> function) {
        return new PairStream<K, V>(this.streamBuilder, this.addProcessorNode(new MapValuesProcessor(function), KEY_VALUE, true));
    }

    public <R> PairStream<K, R> flatMapValues(FlatMapFunction<? super V, ? extends R> function) {
        return new PairStream<K, V>(this.streamBuilder, this.addProcessorNode(new FlatMapValuesProcessor(function), KEY_VALUE, true));
    }

    public <R> PairStream<K, R> aggregateByKey(R initialValue, BiFunction<? super R, ? super V, ? extends R> accumulator, BiFunction<? super R, ? super R, ? extends R> combiner) {
        return this.combineByKey(CombinerAggregator.of(initialValue, accumulator, combiner));
    }

    public <A, R> PairStream<K, R> aggregateByKey(CombinerAggregator<? super V, A, ? extends R> aggregator) {
        return this.combineByKey(aggregator);
    }

    public PairStream<K, Long> countByKey() {
        return this.aggregateByKey(new Count());
    }

    public PairStream<K, V> reduceByKey(Reducer<V> reducer) {
        return this.combineByKey(reducer);
    }

    public PairStream<K, Iterable<V>> groupByKey() {
        return this.partitionByKey().aggregatePartition(new MergeValues());
    }

    public PairStream<K, Iterable<V>> groupByKeyAndWindow(Window<?, ?> window) {
        return ((PairStream)this.partitionByKey().window((Window)window)).aggregatePartition(new MergeValues());
    }

    public PairStream<K, V> reduceByKeyAndWindow(Reducer<V> reducer, Window<?, ?> window) {
        return ((PairStream)this.partitionByKey().window((Window)window)).reduceByKey(reducer);
    }

    public PairStream<K, V> peek(Consumer<? super Pair<K, V>> action) {
        return this.toPairStream(super.peek(action));
    }

    public PairStream<K, V> filter(Predicate<? super Pair<K, V>> predicate) {
        return this.toPairStream(super.filter(predicate));
    }

    public <V1> PairStream<K, Pair<V, V1>> join(PairStream<K, V1> otherStream) {
        return this.join(otherStream, new PairValueJoiner());
    }

    public <R, V1> PairStream<K, R> join(PairStream<K, V1> otherStream, ValueJoiner<? super V, ? super V1, ? extends R> valueJoiner) {
        return this.partitionByKey().joinPartition(otherStream.partitionByKey(), valueJoiner, JoinProcessor.JoinType.INNER, JoinProcessor.JoinType.INNER);
    }

    public <V1> PairStream<K, Pair<V, V1>> leftOuterJoin(PairStream<K, V1> otherStream) {
        return this.leftOuterJoin(otherStream, new PairValueJoiner());
    }

    public <R, V1> PairStream<K, R> leftOuterJoin(PairStream<K, V1> otherStream, ValueJoiner<? super V, ? super V1, ? extends R> valueJoiner) {
        return this.partitionByKey().joinPartition(otherStream.partitionByKey(), valueJoiner, JoinProcessor.JoinType.OUTER, JoinProcessor.JoinType.INNER);
    }

    public <V1> PairStream<K, Pair<V, V1>> rightOuterJoin(PairStream<K, V1> otherStream) {
        return this.rightOuterJoin(otherStream, new PairValueJoiner());
    }

    public <R, V1> PairStream<K, R> rightOuterJoin(PairStream<K, V1> otherStream, ValueJoiner<? super V, ? super V1, ? extends R> valueJoiner) {
        return this.partitionByKey().joinPartition(otherStream.partitionByKey(), valueJoiner, JoinProcessor.JoinType.INNER, JoinProcessor.JoinType.OUTER);
    }

    public <V1> PairStream<K, Pair<V, V1>> fullOuterJoin(PairStream<K, V1> otherStream) {
        return this.fullOuterJoin(otherStream, new PairValueJoiner());
    }

    public <R, V1> PairStream<K, R> fullOuterJoin(PairStream<K, V1> otherStream, ValueJoiner<? super V, ? super V1, ? extends R> valueJoiner) {
        return this.partitionByKey().joinPartition(otherStream.partitionByKey(), valueJoiner, JoinProcessor.JoinType.OUTER, JoinProcessor.JoinType.OUTER);
    }

    public PairStream<K, V> window(Window<?, ?> window) {
        return this.toPairStream(super.window(window));
    }

    public PairStream<K, V> repartition(int parallelism) {
        return this.toPairStream(super.repartition(parallelism));
    }

    public PairStream<K, V>[] branch(Predicate<? super Pair<K, V>> ... predicates) {
        ArrayList<PairStream<K, V>> pairStreams = new ArrayList<PairStream<K, V>>();
        for (Stream<Pair<K, V>> stream : super.branch(predicates)) {
            pairStreams.add(this.toPairStream(stream));
        }
        return pairStreams.toArray(new PairStream[pairStreams.size()]);
    }

    public <R> StreamState<K, R> updateStateByKey(R initialValue, BiFunction<? super R, ? super V, ? extends R> stateUpdateFn) {
        return this.updateStateByKey(StateUpdater.of(initialValue, stateUpdateFn));
    }

    public <R> StreamState<K, R> updateStateByKey(StateUpdater<? super V, ? extends R> stateUpdater) {
        return this.partitionBy(KEY).updateStateByKeyPartition(stateUpdater);
    }

    public <V1> PairStream<K, Pair<Iterable<V>, Iterable<V1>>> coGroupByKey(PairStream<K, V1> otherStream) {
        return this.partitionByKey().coGroupByKeyPartition(otherStream);
    }

    private <R> StreamState<K, R> updateStateByKeyPartition(StateUpdater<? super V, ? extends R> stateUpdater) {
        return new StreamState<K, V>(new PairStream<K, V>(this.streamBuilder, this.addProcessorNode(new UpdateStateByKeyProcessor(stateUpdater), KEY_VALUE, true)));
    }

    private <R, V1> PairStream<K, R> joinPartition(PairStream<K, V1> otherStream, ValueJoiner<? super V, ? super V1, ? extends R> valueJoiner, JoinProcessor.JoinType leftType, JoinProcessor.JoinType rightType) {
        String leftStream = this.stream;
        String rightStream = otherStream.stream;
        Node joinNode = this.addProcessorNode(new JoinProcessor(leftStream, rightStream, valueJoiner, leftType, rightType), KEY_VALUE, true);
        this.addNode(otherStream.getNode(), joinNode, joinNode.getParallelism());
        return new PairStream<K, V>(this.streamBuilder, joinNode);
    }

    private <R, V1> PairStream<K, R> coGroupByKeyPartition(PairStream<K, V1> otherStream) {
        String firstStream = this.stream;
        String secondStream = otherStream.stream;
        Node coGroupNode = this.addProcessorNode(new CoGroupByKeyProcessor(firstStream, secondStream), KEY_VALUE, true);
        this.addNode(otherStream.getNode(), coGroupNode, coGroupNode.getParallelism());
        return new PairStream<K, V>(this.streamBuilder, coGroupNode);
    }

    private PairStream<K, V> partitionByKey() {
        return this.shouldPartitionByKey() ? this.partitionBy(KEY) : this;
    }

    private boolean shouldPartitionByKey() {
        if (this.node.getParallelism() == 1) {
            return false;
        }
        if (this.node instanceof ProcessorNode) {
            Fields fields;
            ProcessorNode pn = (ProcessorNode)this.node;
            Fields fields2 = fields = pn.getGroupingInfo() == null ? null : pn.getGroupingInfo().getFields();
            if (pn.isPreservesKey() && fields != null && fields.equals(KEY)) {
                return false;
            }
        }
        return true;
    }

    private PairStream<K, V> partitionBy(Fields fields) {
        return this.toPairStream(this.partitionBy(fields, this.node.parallelism));
    }

    private PairStream<K, V> toPairStream(Stream<Pair<K, V>> stream) {
        return new PairStream<K, V>(stream.streamBuilder, stream.node);
    }

    private <A, R> PairStream<K, R> aggregatePartition(CombinerAggregator<? super V, A, ? extends R> aggregator) {
        return new PairStream<K, V>(this.streamBuilder, this.addProcessorNode(new AggregateByKeyProcessor(aggregator), KEY_VALUE, true));
    }

    private <A> PairStream<K, A> combinePartition(CombinerAggregator<? super V, A, ?> aggregator) {
        return new PairStream<K, V>(this.streamBuilder, this.addProcessorNode(new AggregateByKeyProcessor(aggregator, true), KEY_VALUE, true));
    }

    private <R> PairStream<K, R> merge(CombinerAggregator<?, V, ? extends R> aggregator) {
        return new PairStream<K, V>(this.streamBuilder, this.addProcessorNode(new MergeAggregateByKeyProcessor(aggregator), KEY_VALUE, true));
    }

    private PairStream<K, V> reducePartition(Reducer<V> reducer) {
        return new PairStream<K, V>(this.streamBuilder, this.addProcessorNode(new ReduceByKeyProcessor(reducer), KEY_VALUE, true));
    }

    private <A, R> PairStream<K, R> combineByKey(CombinerAggregator<? super V, A, ? extends R> aggregator) {
        if (this.shouldPartitionByKey()) {
            Set<Node> parents;
            Optional<Node> nonWindowed;
            if (this.node instanceof ProcessorNode) {
                if (this.node.isWindowed()) {
                    return this.combinePartition(aggregator).partitionBy(KEY).merge(aggregator);
                }
            } else if (this.node instanceof WindowNode && !(nonWindowed = (parents = this.node.getParents()).stream().filter((? super T p) -> !p.isWindowed()).findAny()).isPresent()) {
                parents.forEach((? super T p) -> {
                    ProcessorNode localAggregateNode = this.makeProcessorNode(new AggregateByKeyProcessor(aggregator, true), KEY_VALUE, true);
                    this.streamBuilder.insert((Node)p, localAggregateNode);
                });
                return this.partitionBy(KEY).merge(aggregator);
            }
            return this.partitionBy(KEY).aggregatePartition(aggregator);
        }
        return this.aggregatePartition(aggregator);
    }

    private PairStream<K, V> combineByKey(Reducer<V> reducer) {
        if (this.shouldPartitionByKey()) {
            if (this.node instanceof ProcessorNode) {
                if (this.node.isWindowed()) {
                    return this.reducePartition(reducer).partitionBy(KEY).reducePartition(reducer);
                }
            } else if (this.node instanceof WindowNode) {
                for (Node p : this.node.getParents()) {
                    if (!p.isWindowed()) continue;
                    ProcessorNode localReduceNode = this.makeProcessorNode(new ReduceByKeyProcessor(reducer), KEY_VALUE, true);
                    this.streamBuilder.insert(p, localReduceNode);
                }
            }
            return this.partitionBy(KEY).reducePartition(reducer);
        }
        return this.reducePartition(reducer);
    }

    private static class MergeValues<V>
    implements CombinerAggregator<V, ArrayList<V>, ArrayList<V>> {
        private MergeValues() {
        }

        @Override
        public ArrayList<V> init() {
            return new ArrayList();
        }

        @Override
        public ArrayList<V> apply(ArrayList<V> aggregate, V value) {
            aggregate.add(value);
            return aggregate;
        }

        @Override
        public ArrayList<V> merge(ArrayList<V> accum1, ArrayList<V> accum2) {
            ArrayList<V> res = new ArrayList<V>();
            res.addAll(accum1);
            res.addAll(accum2);
            return res;
        }

        @Override
        public ArrayList<V> result(ArrayList<V> accum) {
            return accum;
        }
    }
}

