/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.zookeeper.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.apache.storm.shade.org.apache.jute.Record;
import org.apache.storm.shade.org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.storm.shade.org.apache.zookeeper.server.RequestRecord;

public class ByteBufferRequestRecord
implements RequestRecord {
    private final ByteBuffer request;
    private volatile Record record;

    public ByteBufferRequestRecord(ByteBuffer request) {
        this.request = request;
    }

    @Override
    public <T extends Record> T readRecord(Supplier<T> constructor) throws IOException {
        if (this.record != null) {
            return (T)this.record;
        }
        this.record = (Record)constructor.get();
        this.request.rewind();
        ByteBufferInputStream.byteBuffer2Record(this.request, this.record);
        this.request.rewind();
        return (T)this.record;
    }

    @Override
    public byte[] readBytes() {
        this.request.rewind();
        int len = this.request.remaining();
        byte[] b = new byte[len];
        this.request.get(b);
        this.request.rewind();
        return b;
    }

    @Override
    public int limit() {
        return this.request.limit();
    }
}

