/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.utils;

import java.util.List;
import java.util.stream.Collectors;

public class ListFunctionalSupport {
    public static <T> T first(List<T> list) {
        if (list == null || list.size() <= 0) {
            return null;
        }
        return list.get(0);
    }

    public static <T> T last(List<T> list) {
        if (list == null || list.size() <= 0) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static <T> List<T> takeLast(List<T> list, int count) {
        if (list == null) {
            return null;
        }
        if (list.size() <= count) {
            return list;
        }
        return list.stream().skip(list.size() - count).limit(count).collect(Collectors.toList());
    }

    public static <T> List<T> drop(List<T> list, int count) {
        if (list == null) {
            return null;
        }
        return list.stream().skip(count).collect(Collectors.toList());
    }

    public static <T> List<T> rest(List<T> list) {
        return ListFunctionalSupport.drop(list, 1);
    }
}

