/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.executor;

import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.storm.daemon.worker.WorkerState;
import org.apache.storm.executor.Executor;
import org.apache.storm.executor.ExecutorTransfer;
import org.apache.storm.tuple.AddressedTuple;
import org.apache.storm.utils.RegisteredGlobalState;

public class LocalExecutor {
    private static volatile String trackId = null;

    public static Executor mkExecutor(WorkerState workerState, List<Long> executorId, Map<String, String> initialCredentials) throws Exception {
        Executor executor = Executor.mkExecutor(workerState, executorId, initialCredentials);
        executor.setLocalExecutorTransfer(new ExecutorTransfer(workerState, (Map)executor.getTopoConf()){

            @Override
            public boolean tryTransfer(AddressedTuple tuple, Queue<AddressedTuple> pendingEmits) {
                if (null != trackId) {
                    ((AtomicInteger)((Map)RegisteredGlobalState.getState(trackId)).get("transferred")).incrementAndGet();
                }
                return super.tryTransfer(tuple, pendingEmits);
            }
        });
        return executor;
    }

    public static void setTrackId(String trackId) {
        LocalExecutor.trackId = trackId;
    }

    public static void clearTrackId() {
        trackId = null;
    }
}

