/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Configuring;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.EmptyIterator;

public class GraphStep<S, E extends Element>
extends AbstractStep<S, E>
implements Configuring,
GraphStepContract<S, E> {
    protected Parameters parameters = new Parameters();
    protected final Class<E> returnClass;
    protected Object[] ids;
    protected transient Supplier<Iterator<E>> iteratorSupplier;
    protected boolean isStart;
    protected boolean done = false;
    private Traverser.Admin<S> head = null;
    private Iterator<E> iterator = EmptyIterator.instance();

    public GraphStep(Traversal.Admin traversal, Class<E> returnClass, boolean isStart, Object ... ids) {
        super(traversal);
        this.returnClass = returnClass;
        for (Object id : this.ids = ids != null && ids.length == 1 && ids[0] instanceof Collection ? ((Collection)ids[0]).toArray(new Object[((Collection)ids[0]).size()]) : ids) {
            if (!(id instanceof GValue)) continue;
            throw new IllegalArgumentException("GValue Not Allowed as id in GraphStep");
        }
        this.isStart = isStart;
        this.iteratorSupplier = () -> Vertex.class.isAssignableFrom(this.returnClass) ? this.getTraversal().getGraph().get().vertices(this.ids) : this.getTraversal().getGraph().get().edges(this.ids);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.returnClass.getSimpleName().toLowerCase(), Arrays.toString(this.ids));
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public void configure(Object ... keyValues) {
        this.parameters.set(null, keyValues);
    }

    @Override
    public Class<E> getReturnClass() {
        return this.returnClass;
    }

    @Override
    public boolean isStartStep() {
        return this.isStart;
    }

    public static boolean isStartStep(Step<?, ?> step) {
        return step instanceof GraphStep && ((GraphStep)step).isStart;
    }

    @Override
    public boolean returnsVertex() {
        return this.returnClass.equals(Vertex.class);
    }

    @Override
    public boolean returnsEdge() {
        return this.returnClass.equals(Edge.class);
    }

    public void setIteratorSupplier(Supplier<Iterator<E>> iteratorSupplier) {
        this.iteratorSupplier = iteratorSupplier;
    }

    @Override
    public Object[] getIds() {
        return this.ids;
    }

    public void addIds(Object ... newIds) {
        this.ids = (this.ids == null || this.ids.length == 0) && newIds.length == 1 && newIds[0] instanceof Collection && ((Collection)newIds[0]).isEmpty() ? null : ArrayUtils.addAll((Object[])this.ids, (Object[])(newIds.length == 1 && newIds[0] instanceof Collection ? ((Collection)newIds[0]).toArray(new Object[((Collection)newIds[0]).size()]) : newIds));
    }

    @Override
    public void clearIds() {
        this.ids = new Object[0];
    }

    @Override
    public void onGraphComputer() {
        this.iteratorSupplier = Collections::emptyIterator;
        this.convertElementsToIds();
    }

    public void convertElementsToIds() {
        if (null != this.ids) {
            for (int i = 0; i < this.ids.length; ++i) {
                if (!(this.ids[i] instanceof Element)) continue;
                this.ids[i] = ((Element)this.ids[i]).id();
            }
        }
    }

    @Override
    protected Traverser.Admin<E> processNextStart() {
        while (!this.iterator.hasNext()) {
            if (this.isStart) {
                if (this.done) {
                    throw FastNoSuchElementException.instance();
                }
                this.done = true;
                this.iterator = null == this.iteratorSupplier ? EmptyIterator.instance() : this.iteratorSupplier.get();
                continue;
            }
            this.head = this.starts.next();
            this.iterator = null == this.iteratorSupplier ? EmptyIterator.instance() : this.iteratorSupplier.get();
        }
        return this.isStart ? this.getTraversal().getTraverserGenerator().generate((Element)this.iterator.next(), this, 1L) : this.head.split((Element)this.iterator.next(), this);
    }

    @Override
    public void reset() {
        super.reset();
        this.head = null;
        this.done = false;
        this.iterator = EmptyIterator.instance();
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.returnClass);
        if (this.ids != null) {
            for (Object id : this.ids) {
                result = 31 * result + Objects.hashCode(id);
            }
        }
        return result;
    }

    @Override
    public void close() {
        CloseableIterator.closeIterator(this.iterator);
    }

    public static boolean processHasContainerIds(GraphStep<?, ?> graphStep, HasContainer hasContainer) {
        String key = hasContainer.getKey();
        if (key != null && key.equals(T.id.getAccessor()) && graphStep.ids.length == 0 && (hasContainer.getBiPredicate() == Compare.eq || hasContainer.getBiPredicate() == Contains.within)) {
            graphStep.addIds(hasContainer.getValue());
            return true;
        }
        return false;
    }
}

