/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValueHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TailLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TailLocalStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class TailLocalStepPlaceholder<S>
extends ScalarMapStep<S, S>
implements TailLocalStepContract<S>,
GValueHolder<S, S> {
    private GValue<Long> limit;

    public TailLocalStepPlaceholder(Traversal.Admin traversal, GValue<Long> limit) {
        super(traversal);
        if (null == limit) {
            throw new IllegalArgumentException("TailLocalStepPlaceholder requires limit to be non-null");
        }
        this.limit = limit;
        if (this.limit.isVariable()) {
            traversal.getGValueManager().register(limit);
        }
    }

    @Override
    protected S map(Traverser.Admin<S> traverser) {
        throw new IllegalStateException("GValueHolder is not executable");
    }

    @Override
    public TailLocalStepPlaceholder<S> clone() {
        TailLocalStepPlaceholder clone = (TailLocalStepPlaceholder)super.clone();
        clone.limit = this.limit.clone();
        return clone;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TailLocalStepPlaceholder that = (TailLocalStepPlaceholder)o;
        return Objects.equals(this.limit, that.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.limit);
    }

    @Override
    public Long getLimit() {
        if (this.limit.isVariable()) {
            this.traversal.getGValueManager().pinVariable(this.limit.getName());
        }
        return this.limit.get();
    }

    @Override
    public GValue<Long> getLimitAsGValue() {
        return this.limit;
    }

    public TailLocalStep<S> asConcreteStep() {
        TailLocalStep step = new TailLocalStep(this.traversal, this.limit.get());
        TraversalHelper.copyLabels(this, step, false);
        return step;
    }

    @Override
    public boolean isParameterized() {
        return this.limit.isVariable();
    }

    @Override
    public void updateVariable(String name, Object value) {
        if (name.equals(this.limit.getName())) {
            if (!(value instanceof Number)) {
                throw new IllegalArgumentException("The variable " + name + " must have a value of type Number");
            }
            this.limit = GValue.ofLong(name, ((Number)value).longValue());
        }
    }

    @Override
    public Collection<GValue<?>> getGValues() {
        return Collections.singletonList(this.limit);
    }
}

