/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GlobalOrdinalFieldStats
implements JsonpSerializable {
    private final long buildTimeInMillis;
    @Nullable
    private final String buildTime;
    private final long shardMaxValueCount;
    public static final JsonpDeserializer<GlobalOrdinalFieldStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GlobalOrdinalFieldStats::setupGlobalOrdinalFieldStatsDeserializer);

    private GlobalOrdinalFieldStats(Builder builder) {
        this.buildTimeInMillis = ApiTypeHelper.requireNonNull(builder.buildTimeInMillis, (Object)this, "buildTimeInMillis", 0L);
        this.buildTime = builder.buildTime;
        this.shardMaxValueCount = ApiTypeHelper.requireNonNull(builder.shardMaxValueCount, (Object)this, "shardMaxValueCount", 0L);
    }

    public static GlobalOrdinalFieldStats of(Function<Builder, ObjectBuilder<GlobalOrdinalFieldStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long buildTimeInMillis() {
        return this.buildTimeInMillis;
    }

    @Nullable
    public final String buildTime() {
        return this.buildTime;
    }

    public final long shardMaxValueCount() {
        return this.shardMaxValueCount;
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("build_time_in_millis");
        generator.write(this.buildTimeInMillis);
        if (this.buildTime != null) {
            generator.writeKey("build_time");
            generator.write(this.buildTime);
        }
        generator.writeKey("shard_max_value_count");
        generator.write(this.shardMaxValueCount);
    }

    public String toString() {
        return JsonpUtils.toString((JsonpSerializable)this);
    }

    protected static void setupGlobalOrdinalFieldStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::buildTimeInMillis, JsonpDeserializer.longDeserializer(), "build_time_in_millis");
        op.add(Builder::buildTime, JsonpDeserializer.stringDeserializer(), "build_time");
        op.add(Builder::shardMaxValueCount, JsonpDeserializer.longDeserializer(), "shard_max_value_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GlobalOrdinalFieldStats> {
        private Long buildTimeInMillis;
        @Nullable
        private String buildTime;
        private Long shardMaxValueCount;

        public final Builder buildTimeInMillis(long value) {
            this.buildTimeInMillis = value;
            return this;
        }

        public final Builder buildTime(@Nullable String value) {
            this.buildTime = value;
            return this;
        }

        public final Builder shardMaxValueCount(long value) {
            this.shardMaxValueCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GlobalOrdinalFieldStats build() {
            this._checkSingleUse();
            return new GlobalOrdinalFieldStats(this);
        }
    }
}

